package org.pgusb.usb4allLib;

import exceptions.Usb4allException;

public class TemperatureSensor extends Usb4allDevice {
	private static final int IN_ENDPOINT_TYPE = Usb4allDevice.BULK_IN; //Replace with the prefered In Endpoint Type.
	private static final int OUT_ENDPOINT_TYPE = Usb4allDevice.BULK_OUT; //Replace with the prefered Out Endpoint Type.

	public TemperatureSensor(String moduleName){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		this.moduleName=moduleName;
	}
	
	public TemperatureSensor(){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		moduleName="temp"; //Put the name of the firmware module.
		/*StringBuffer nullterm = new StringBuffer(1);
		nullterm.append((char)('p'));
		moduleName.concat(nullterm.toString());*/
	}

	public int getVersion(){
		byte[] command = new byte[1];
		byte[] version = null;
		command[0]=0x00;
		try {
			send(command);
			version = receive(4);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("La version es:" +" "+ version[0] +  " "+ version[1] +" "+ version[2] +" "+ version[3]);
		return 1;
	}

	public float getTemp(){
		byte[] command   = new byte[2];
		byte[] respuesta = new byte[3];
		int rawval, rawtemp;
		float degCtemp = 0;
		command[0]=0x34;
		command[1]=0x02;
		try {
			send(command);
			respuesta = receive(5);
			rawval = respuesta[1] + (respuesta[2]<<8);
			rawtemp = (rawval)>>3;
			degCtemp = (float) (rawtemp * 0.0625);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return degCtemp;
	}
}
